
// ScfPlayerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScfPlayer.h"
#include "ScfPlayerDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CScfPlayerDlg dialog


CScfPlayerDlg::CScfPlayerDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CScfPlayerDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CScfPlayerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CScfPlayerDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_DESTROY()
	ON_WM_QUERYDRAGICON()
END_MESSAGE_MAP()


// CScfPlayerDlg message handlers

BOOL CScfPlayerDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE MAIN WINDOW
	//
	CRect oWindowRect; GetWindowRect( &oWindowRect );

	CRect oClientRect; GetClientRect( &oClientRect );

	ULONG cx = oWindowRect.Width() - oClientRect.Width();						// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	ULONG cy = oWindowRect.Height() - oClientRect.Height();						// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	MoveWindow( 0, 0, cx + DEFAULT_NORMAL_WIDTH, cy + DEFAULT_NORMAL_HEIGHT );	// CREATE AND MAINTIN LAYOUT

	SetWindowPos( &CWnd::wndTop, 0, 0, 0, 0, SWP_NOSIZE );						// SET THE LOCATION OF MAIN DIALOG

	CHAR szStr[ MAX_PATH ] = { 0 };

	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )	
	{			
		m_rect_slipts_display[ i ] = GetSplitWndPos( i, DEFAULT_GRID_DIVISIONS, cx + 960, cy + 540 );		

		sprintf( szStr, "MyChannelWindowLIVE#%02d", i + 1 );

		m_oChannelWindows[ i ].Create(	NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, m_rect_slipts_display[ i ], this, i + 0x00000001, NULL );	// VIDEO WINDOW
			
		sprintf( szStr, "MyChannelWindowBK#%02d", i + 1 );		

		m_oChannelWindows[ i ].ShowWindow( TRUE );
	}

	QCAP_SET_SYSTEM_CONFIGURATION( TRUE, TRUE, TRUE, TRUE, TRUE, 3000, TRUE );

	// INITIALIZE SETUP DIALOG
	//
	HMONITOR hMonitor = MonitorFromWindow( m_hWnd, MONITOR_DEFAULTTONEAREST );			

	MONITORINFO sMonitorInfo = { sizeof(MONITORINFO), }; 
			
	GetMonitorInfo( hMonitor, &sMonitorInfo );

	CRect oMonitorRect = sMonitorInfo.rcWork;			
			
	m_oSetupDialog.Create( IDD_SETUP_DIALOG, this );

	m_oSetupDialog.GetWindowRect( &oWindowRect );

	m_oSetupDialog.GetClientRect( &oClientRect );

	cx = oWindowRect.Width() - oClientRect.Width();		// GET DEFAULT BOUNDARY WIDTH OF DIALOG

	cy = oWindowRect.Height() - oClientRect.Height();	// GET DEFAULT BOUNDARY HEIGHT OF DIALOG

	m_oSetupDialog.SetWindowPos( &(CWnd::wndTop), (oMonitorRect.Width() - (960 + cx)) / 2, (oMonitorRect.Height() - (105 + 40 + cy)), (cx + 1400),  (cy + 330), (NULL));

	m_oSetupDialog.ShowWindow( TRUE );		

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CScfPlayerDlg::OnDestroy() 
{
	CDialogEx::OnDestroy();
	
	// TODO: Add your message handler code here

	// UNINITIALIZE USER INTERFACE RESOURCE
	//
	for ( ULONG i = 0; i < DEFAULT_MAX_CHANNEL_NUM; i++ )
	{	
		m_oChannelWindows[ i ].DestroyWindow();
	}

	m_oSetupDialog.DestroyWindow();	

	// UNINITIALIZE COM RESOURCE
	//
	CoUninitialize();
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CScfPlayerDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{	
		CDialogEx::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CScfPlayerDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

CRect CScfPlayerDlg::GetSplitWndPos( ULONG nChannelNumber, ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / nGridDivisions;
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; 

	ULONG nMaxChannel = nGridDivisions * nGridDivisions;

	ULONG x = nChannelNumber / nGridDivisions;

	ULONG y = nChannelNumber % nGridDivisions;

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;
			
	return CRect( top, left, bottom, right );
}