// SetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ScfPlayer.h"
#include "ScfPlayerDlg.h"
#include "SetupDlg.h"
#include "afxdialogex.h"

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

QRETURN on_video_decoder_file_callback( ULONG nChannelNumber, PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//SC_DEBUG( "CH%02d on_video_decoder_file_callback", nChannelNumber + 1 );

	CSetupDlg * pMainDlg = (CSetupDlg *)(pUserData);

	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( ULONG nChannelNumber, PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	//SC_DEBUG( "CH%02d on_audio_decoder_file_callback", nChannelNumber + 1 );

	CSetupDlg * pMainDlg = (CSetupDlg *)(pUserData);

	return QCAP_RT_OK;
}

QRETURN on_video_decoder_file_callback_CH01( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000000, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH02( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000001, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH03( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000002, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH04( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000003, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH05( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000004, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH06( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000005, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH07( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000006, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH08( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000007, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_video_decoder_file_callback_CH09( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_video_decoder_file_callback( 0x00000008, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

QRETURN on_audio_decoder_file_callback_CH01( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000000, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH02( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000001, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH03( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000002, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH04( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000003, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH05( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000004, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH06( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000005, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH07( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000006, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH08( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000007, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }
QRETURN on_audio_decoder_file_callback_CH09( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData ) { return on_audio_decoder_file_callback( 0x00000008, pFile, dSampleTime, pFrameBuffer, nFrameBufferLen, pUserData ); }

PF_VIDEO_DECODER_FILE_CALLBACK g_on_video_decoder_file_callback[ DEFAULT_MAX_CHANNEL_NUM ] = 
{
	on_video_decoder_file_callback_CH01, on_video_decoder_file_callback_CH02, 
	on_video_decoder_file_callback_CH03, on_video_decoder_file_callback_CH04,
	on_video_decoder_file_callback_CH05, on_video_decoder_file_callback_CH06,
	on_video_decoder_file_callback_CH07, on_video_decoder_file_callback_CH08,
	on_video_decoder_file_callback_CH09
};

PF_AUDIO_DECODER_FILE_CALLBACK g_on_audio_decoder_file_callback[ DEFAULT_MAX_CHANNEL_NUM ] = 
{
	on_audio_decoder_file_callback_CH01, on_audio_decoder_file_callback_CH02, 
	on_audio_decoder_file_callback_CH03, on_audio_decoder_file_callback_CH04,
	on_audio_decoder_file_callback_CH05, on_audio_decoder_file_callback_CH06,
	on_audio_decoder_file_callback_CH07, on_audio_decoder_file_callback_CH08,
	on_audio_decoder_file_callback_CH09
};

// CSetupDlg dialog

IMPLEMENT_DYNAMIC(CSetupDlg, CDialog)

CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDlg::IDD, pParent)
	, m_bChkCH01( TRUE ), m_bChkCH02( TRUE ), m_bChkCH03( TRUE ), m_bChkCH04( TRUE ), m_bChkCH05( TRUE ), m_bChkCH06( TRUE ), m_bChkCH07( TRUE ), m_bChkCH08( TRUE ), m_bChkCH09( TRUE )
{
	m_bGlobalPlay = FALSE;

	ULONG i = 0;

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		m_nRecordCout[ i ]		= 0;

		m_pScfFile[ i ]			= NULL;
	}
}

CSetupDlg::~CSetupDlg()
{
}

void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
//{{AFX_DATA_MAP(CSetupDlg)
	DDX_Control(pDX, IDC_MONTHCALENDAR, m_ctlMonthCalendar);	
	DDX_Check(pDX, IDC_CHK_CH01, m_bChkCH01);
	DDX_Check(pDX, IDC_CHK_CH02, m_bChkCH02);
	DDX_Check(pDX, IDC_CHK_CH03, m_bChkCH03);
	DDX_Check(pDX, IDC_CHK_CH04, m_bChkCH04);
	DDX_Check(pDX, IDC_CHK_CH05, m_bChkCH05);
	DDX_Check(pDX, IDC_CHK_CH06, m_bChkCH06);
	DDX_Check(pDX, IDC_CHK_CH07, m_bChkCH07);
	DDX_Check(pDX, IDC_CHK_CH08, m_bChkCH08);
	DDX_Check(pDX, IDC_CHK_CH09, m_bChkCH09);
//}}AFX_DATA_MAP	
}


BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CSetupDlg)
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_SYSCOMMAND()
	ON_NOTIFY(MCN_SELCHANGE, IDC_MONTHCALENDAR, &CSetupDlg::OnMcnSelchangeMonthcalendar)
	ON_BN_CLICKED(IDC_BTN_ENUM, &CSetupDlg::OnBnClickedBtnEnum)
	ON_BN_CLICKED(IDC_BTN_PLAY1, &CSetupDlg::OnBnClickedBtnPlay1)
	ON_BN_CLICKED(IDC_BTN_PAUSE1, &CSetupDlg::OnBnClickedBtnPause1)
	ON_BN_CLICKED(IDC_BTN_STOP1, &CSetupDlg::OnBnClickedBtnStop1)
	ON_BN_CLICKED(IDC_BTN_PLAY2, &CSetupDlg::OnBnClickedBtnPlay2)
	ON_BN_CLICKED(IDC_BTN_PAUSE2, &CSetupDlg::OnBnClickedBtnPause2)
	ON_BN_CLICKED(IDC_BTN_STOP2, &CSetupDlg::OnBnClickedBtnStop2)
	ON_BN_CLICKED(IDC_BTN_PLAY3, &CSetupDlg::OnBnClickedBtnPlay3)
	ON_BN_CLICKED(IDC_BTN_PAUSE3, &CSetupDlg::OnBnClickedBtnPause3)
	ON_BN_CLICKED(IDC_BTN_STOP3, &CSetupDlg::OnBnClickedBtnStop3)
	ON_BN_CLICKED(IDC_BTN_PLAY4, &CSetupDlg::OnBnClickedBtnPlay4)
	ON_BN_CLICKED(IDC_BTN_PAUSE4, &CSetupDlg::OnBnClickedBtnPause4)
	ON_BN_CLICKED(IDC_BTN_STOP4, &CSetupDlg::OnBnClickedBtnStop4)
	ON_BN_CLICKED(IDC_BTN_PLAY5, &CSetupDlg::OnBnClickedBtnPlay5)
	ON_BN_CLICKED(IDC_BTN_PAUSE5, &CSetupDlg::OnBnClickedBtnPause5)
	ON_BN_CLICKED(IDC_BTN_STOP5, &CSetupDlg::OnBnClickedBtnStop5)
	ON_BN_CLICKED(IDC_BTN_PLAY6, &CSetupDlg::OnBnClickedBtnPlay6)
	ON_BN_CLICKED(IDC_BTN_PAUSE6, &CSetupDlg::OnBnClickedBtnPause6)
	ON_BN_CLICKED(IDC_BTN_STOP6, &CSetupDlg::OnBnClickedBtnStop6)
	ON_BN_CLICKED(IDC_BTN_PLAY7, &CSetupDlg::OnBnClickedBtnPlay7)
	ON_BN_CLICKED(IDC_BTN_PAUSE7, &CSetupDlg::OnBnClickedBtnPause7)
	ON_BN_CLICKED(IDC_BTN_STOP7, &CSetupDlg::OnBnClickedBtnStop7)
	ON_BN_CLICKED(IDC_BTN_PLAY8, &CSetupDlg::OnBnClickedBtnPlay8)
	ON_BN_CLICKED(IDC_BTN_PAUSE8, &CSetupDlg::OnBnClickedBtnPause8)
	ON_BN_CLICKED(IDC_BTN_STOP8, &CSetupDlg::OnBnClickedBtnStop8)
	ON_BN_CLICKED(IDC_BTN_PLAY9, &CSetupDlg::OnBnClickedBtnPlay9)
	ON_BN_CLICKED(IDC_BTN_PAUSE9, &CSetupDlg::OnBnClickedBtnPause9)
	ON_BN_CLICKED(IDC_BTN_STOP9, &CSetupDlg::OnBnClickedBtnStop9)
	ON_BN_CLICKED(IDC_CHK_CH01, &CSetupDlg::OnBnClickedChkCh01)
	ON_BN_CLICKED(IDC_CHK_CH02, &CSetupDlg::OnBnClickedChkCh02)
	ON_BN_CLICKED(IDC_CHK_CH03, &CSetupDlg::OnBnClickedChkCh03)
	ON_BN_CLICKED(IDC_CHK_CH04, &CSetupDlg::OnBnClickedChkCh04)
	ON_BN_CLICKED(IDC_CHK_CH05, &CSetupDlg::OnBnClickedChkCh05)
	ON_BN_CLICKED(IDC_CHK_CH06, &CSetupDlg::OnBnClickedChkCh06)
	ON_BN_CLICKED(IDC_CHK_CH07, &CSetupDlg::OnBnClickedChkCh07)
	ON_BN_CLICKED(IDC_CHK_CH08, &CSetupDlg::OnBnClickedChkCh08)
	ON_BN_CLICKED(IDC_CHK_CH09, &CSetupDlg::OnBnClickedChkCh09)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_GLOBAL_PLAY, &CSetupDlg::OnBnClickedBtnGlobalPlay)
	ON_BN_CLICKED(IDC_BTN_GLOBAL_PAUSE, &CSetupDlg::OnBnClickedBtnGlobalPause)
	ON_BN_CLICKED(IDC_BTN_GLOBAL_STOP, &CSetupDlg::OnBnClickedBtnGlobalStop)
	ON_BN_CLICKED(IDC_BTN_SEARCH, &CSetupDlg::OnBnClickedBtnSearch)
END_MESSAGE_MAP()

// CSetupDlg message handlers

BOOL CSetupDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CHAR szStr[ MAX_PATH ] = { 0 };

	sprintf( szStr, "MyRecordWindowLIVE#%02d", 0 );

	CRect rect_record_display;

	rect_record_display.left	= 60;
	rect_record_display.top		= 0;
	rect_record_display.right	= 960;
	rect_record_display.bottom	= 313; //285;

	m_oRecordWindows.Create( NULL, szStr, WS_CHILD | WS_VISIBLE | WS_BORDER, rect_record_display, this, 0, NULL );	// VIDEO WINDOW

	m_oRecordWindows.ShowWindow( TRUE );

	m_ctlMonthCalendar.SetColor( MCSC_MONTHBK, ::GetSysColor(CTLCOLOR_DLG));

	m_ctlMonthCalendar.SetColor( MCSC_BACKGROUND , ::GetSysColor(CTLCOLOR_DLG));		

	// CLEAN UP DATE STATE
	//
	SYSTEMTIME timeFrom, timeUntil;

	int nCount = m_ctlMonthCalendar.GetMonthRange(&timeFrom, &timeUntil, GMR_DAYSTATE);   	

	LPMONTHDAYSTATE pDayState;

	pDayState = new MONTHDAYSTATE[nCount];

	memset(pDayState, 0, sizeof(MONTHDAYSTATE) * nCount);
	
	m_ctlMonthCalendar.SetDayState(nCount, pDayState);

	delete [] pDayState;

	ShowRecordsDay();

	SetTimer( 0x00000000, 1000, NULL );

	SetTimer( 0x00000001, 1000, NULL );

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CSetupDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here	

	KillTimer( 0x00000000 );

	KillTimer( 0x00000001 );

	QCAP_STOP_GLOBAL_SCF_FILE();

	for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		if ( m_pScfFile[ i ] != NULL ) { QCAP_DESTROY_FILE( m_pScfFile[ i ] );	m_pScfFile[ i ] = NULL; }
	}
}

void CSetupDlg::OnSysCommand(UINT nID, LPARAM lParam) 
{
	// TODO: Add your message handler code here and/or call default

	CScfPlayerDlg * m_pMainDialog = (CScfPlayerDlg *)AfxGetMainWnd();

	if ( nID == SC_CLOSE ) 
	{ 
		::SendMessage( AfxGetMainWnd()->m_hWnd, WM_SYSCOMMAND, SC_CLOSE, 0  );
    }

	CDialog::OnSysCommand(nID, lParam);
}

BOOL CSetupDlg::OnEraseBkgnd(CDC* pDC) 
{	
	return CDialog::OnEraseBkgnd( pDC );
}

void CSetupDlg::OnPaint()
{
	CDialog::OnPaint();
}


void CSetupDlg::OnMcnSelchangeMonthcalendar(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMSELCHANGE pSelChange = reinterpret_cast<LPNMSELCHANGE>(pNMHDR);

	// TODO: Add your control notification handler code here

	//ShowRecordsDay();

	*pResult = 0;
}

void CSetupDlg::OnBnClickedBtnEnum()
{
	// TODO: Add your control notification handler code here	
	
	SYSTEMTIME timeSelectedDay;

	m_ctlMonthCalendar.GetCurSel( &timeSelectedDay );

	SYSTEMTIME sysStartTime, sysEndTime;

	sysStartTime.wYear			= timeSelectedDay.wYear;
	sysStartTime.wMonth			= timeSelectedDay.wMonth;
	sysStartTime.wDay			= timeSelectedDay.wDay;
	sysStartTime.wHour			= 0;
	sysStartTime.wMinute		= 0;
	sysStartTime.wSecond		= 0;
	sysStartTime.wMilliseconds	= 0;

	sysEndTime.wYear			= timeSelectedDay.wYear;
	sysEndTime.wMonth			= timeSelectedDay.wMonth;
	sysEndTime.wDay				= timeSelectedDay.wDay;
	sysEndTime.wHour			= 23;
	sysEndTime.wMinute			= 59;
	sysEndTime.wSecond			= 59;
	sysEndTime.wMilliseconds	= 999;

	ULONGLONG nStartPlayTime = 0, nStopPlayTime = 0;

	SystemTimeToFileTime(&sysStartTime, (FILETIME *)&nStartPlayTime);

	SystemTimeToFileTime(&sysEndTime, (FILETIME *)&nStopPlayTime);

	double dStartSearchTime = 0.0, dStopSearchTime = 0.0;	

	dStartSearchTime = (double)(nStartPlayTime / 10000000);

	dStopSearchTime = (double)(nStopPlayTime / 10000000);

	ULONG nVideoEncoderFormat = 0;

	ULONG nAudioEncoderFormat = 0;

	ULONG nVideoWidth = 0, nVideoHeight = 0;	
	
	double dVideoFrameRate = 0.0;
	
	ULONG nAudioChannels = 0;
	
	ULONG nAudioBitsPerSample = 0;
	
	ULONG nAudioSampleFrequency = 0;

	double dFileStartTime = 0.0;
	
	double dFileStopTime = 0.0;

	double dVideoStartTime = 0.0;

	double dVideoStopTime = 0.0;

	double dTotalDurationTimes = 0.0;

	ULONG nTotalVideoFrames = 0;

	ULONG nTotalAudioFrames = 0;	

	MY_SCF_FILE_INFO  dsFileInfo;

	QRESULT returns = QCAP_RS_SUCCESSFUL;	

	ULONG i = 0;

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		if ( m_pScfFile[ i ] != NULL ) { QCAP_DESTROY_FILE( m_pScfFile[ i ] );	m_pScfFile[ i ] = NULL; }	

		m_vs_file_info[ i ].clear();

		m_nRecordCout[ i ] = 0;
	}

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		returns = QCAP_RS_SUCCESSFUL;

		while( returns == QCAP_RS_SUCCESSFUL )
		{
			returns = QCAP_SCF_FILE_ENUMERATION( i, dStartSearchTime, dStopSearchTime, NULL, NULL, &dFileStartTime, &dFileStopTime, &dVideoStartTime, &dVideoStopTime, NULL, NULL, 
		
												&nVideoEncoderFormat, &nVideoWidth, &nVideoHeight, &dVideoFrameRate, 
												
												&nAudioEncoderFormat, &nAudioChannels, &nAudioBitsPerSample, &nAudioSampleFrequency, 
		
												&dTotalDurationTimes, &nTotalVideoFrames, &nTotalAudioFrames, TRUE );		

			if ( returns != QCAP_RS_SUCCESSFUL ) { break; }

			dsFileInfo.dFileStartTime			= dFileStartTime;
			dsFileInfo.dFileStopTime			= dFileStopTime;
			dsFileInfo.dVideoStartTime			= dVideoStartTime;

			ULONGLONG nPlayTime = (ULONGLONG)(dVideoStartTime * 10000000);

			SYSTEMTIME timePlay; FileTimeToSystemTime( (FILETIME *)(&nPlayTime), &timePlay);

			dsFileInfo.dVideoStopTime			= dVideoStopTime;
			dsFileInfo.m_nVideoEncoderFormat	= nVideoEncoderFormat;
			dsFileInfo.m_nAudioEncoderFormat	= nAudioEncoderFormat;
			dsFileInfo.m_nVideoWidth			= nVideoWidth;
			dsFileInfo.m_nVideoHeight			= nVideoHeight;
			dsFileInfo.m_dVideoFrameRate		= dVideoFrameRate;
			dsFileInfo.m_nAudioChannels			= nAudioChannels;
			dsFileInfo.m_nAudioBitsPerSample	= nAudioBitsPerSample;
			dsFileInfo.m_nAudioSampleFrequency  = nAudioSampleFrequency;
			dsFileInfo.m_dTotalDurationTimes	= dTotalDurationTimes;
			dsFileInfo.m_dTotalVideoFrames		= nTotalVideoFrames;
			dsFileInfo.m_dTotalAudioFrames		= nTotalAudioFrames;

			m_vs_file_info[ i ].push_back( dsFileInfo );

			m_nRecordCout[ i ]++;
		}
	}

	m_oRecordWindows.m_timeDaySelected.wYear         = timeSelectedDay.wYear;
	m_oRecordWindows.m_timeDaySelected.wMonth        = timeSelectedDay.wMonth;
	m_oRecordWindows.m_timeDaySelected.wDay			 = timeSelectedDay.wDay;
	m_oRecordWindows.m_timeDaySelected.wHour         = 0;
	m_oRecordWindows.m_timeDaySelected.wMinute       = 0;
	m_oRecordWindows.m_timeDaySelected.wSecond       = 0;
	m_oRecordWindows.m_timeDaySelected.wMilliseconds = 0;	

	UpdateData();

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )
	{
		m_oRecordWindows.UpdateDataRect( i );
	}

	m_oRecordWindows.Invalidate();

	CScfPlayerDlg * m_pMainDialog = (CScfPlayerDlg *)AfxGetMainWnd();	

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )	
	{
		if ( m_nRecordCout[ i ] > 0 )
		{
			QRESULT returns = QCAP_RS_SUCCESSFUL;
		
			returns = QCAP_OPEN_SCF_FILE( i, &m_pScfFile[ i ], QCAP_DECODER_TYPE_SOFTWARE, m_pMainDialog->m_oChannelWindows[ i ], TRUE, FALSE, dStartSearchTime, dStopSearchTime );			
		}
	}

	for ( i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )	
	{
		if ( m_nRecordCout[ i ] > 0 )
		{
			QRESULT returns = QCAP_RS_SUCCESSFUL;

			returns = QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pScfFile[ i ], g_on_video_decoder_file_callback[ i ], this );

			returns = QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pScfFile[ i ], g_on_audio_decoder_file_callback[ i ], this );
		}
	}
}

VOID CSetupDlg::ShowRecordsDay()
{	
	int nCount = 0;

	BOOL bHasRecords[ 31 ] = {0};

	ULONG nDays = 31;

	SYSTEMTIME timeFrom, timeUntil, timeStartSearch, timeStopSearch;

	nCount = m_ctlMonthCalendar.GetMonthRange(&timeFrom, &timeUntil, GMR_DAYSTATE);

	timeStartSearch.wYear  = timeFrom.wYear;

	if ( timeFrom.wMonth == 12 )
	{
		timeStartSearch.wMonth = 1;
		timeStartSearch.wYear = timeFrom.wYear + 1;
	}
	else
	{
		timeStartSearch.wMonth = timeFrom.wMonth + 1;
	}

	timeStartSearch.wDay			= 1;
	timeStartSearch.wHour			= 0;
	timeStartSearch.wMinute			= 0;
	timeStartSearch.wSecond			= 0;
	timeStartSearch.wMilliseconds	= 0;

	timeStopSearch.wYear			= timeStartSearch.wYear;
	timeStopSearch.wMonth			= timeStartSearch.wMonth;
	timeStopSearch.wDay				= timeStartSearch.wDay;
	timeStopSearch.wHour			= 23;
	timeStopSearch.wMinute			= 59;
	timeStopSearch.wSecond			= 59;
	timeStopSearch.wMilliseconds	= 999;

	ULONGLONG nStartSearchTime = 0, nStopSearchTime = 0;

	SystemTimeToFileTime(&timeStartSearch, (FILETIME *)&nStartSearchTime);

	SystemTimeToFileTime(&timeStopSearch, (FILETIME *)&nStopSearchTime);

	double dStartSearchTime = 0.0, dStopSearchTime = 0.0;	

	QRESULT returns = QCAP_RS_SUCCESSFUL;

	MY_SCF_FILE_INFO  dsFileInfo = {0};

	ULONG nVideoEncoderFormat = 0;

	ULONG nAudioEncoderFormat = 0;

	ULONG nVideoWidth = 0, nVideoHeight = 0;	
	
	double dVideoFrameRate = 0.0;
	
	ULONG nAudioChannels = 0;
	
	ULONG nAudioBitsPerSample = 0;
	
	ULONG nAudioSampleFrequency = 0;

	double dFileStartTime = 0.0;
	
	double dFileStopTime = 0.0;

	double dVideoStartTime = 0.0;

	double dVideoStopTime = 0.0;

	double dTotalDurationTimes = 0.0;

	ULONG nTotalVideoFrames = 0;

	ULONG nTotalAudioFrames = 0;	

	for ( ULONG i = 1 ; i <= nDays ; i++ )
	{
		returns = QCAP_RS_SUCCESSFUL;

		timeStartSearch.wDay = (WORD)i;

		timeStopSearch.wDay = (WORD)i;

		SystemTimeToFileTime(&timeStartSearch, (FILETIME *)&nStartSearchTime);

		SystemTimeToFileTime(&timeStopSearch, (FILETIME *)&nStopSearchTime);

		dStartSearchTime = (double)(nStartSearchTime / 10000000);

		dStopSearchTime = (double)(nStopSearchTime / 10000000);

		BOOL bFindData = FALSE;

		while( returns == QCAP_RS_SUCCESSFUL )
		{
			for ( ULONG j = 0 ; j < DEFAULT_MAX_CHANNEL_NUM ; j++ )
			{
				returns = QCAP_RS_ERROR_GENERAL;

				returns = QCAP_SCF_FILE_ENUMERATION( j, dStartSearchTime, dStopSearchTime, NULL, NULL, &dFileStartTime, &dFileStopTime, &dVideoStartTime, &dVideoStopTime, NULL, NULL, 
		
													&nVideoEncoderFormat, &nVideoWidth, &nVideoHeight, &dVideoFrameRate, 
												
													&nAudioEncoderFormat, &nAudioChannels, &nAudioBitsPerSample, &nAudioSampleFrequency, 
		
													&dTotalDurationTimes, &nTotalVideoFrames, &nTotalAudioFrames, TRUE );		

				if ( returns != QCAP_RS_SUCCESSFUL ) { break; }

				bFindData = TRUE;
			}
		}

		if ( bFindData )
		{
			bHasRecords[ i - 1 ] = TRUE;
		}		
	}
	
	LPMONTHDAYSTATE pDayState;

	pDayState = new MONTHDAYSTATE[ nCount ];

	memset(pDayState, 0, sizeof(MONTHDAYSTATE) * nCount);

	int nIndex = 1;	

	// SET THE DAYs OF THE MONTH
	//
	for ( ULONG i = 0 ; i < nDays ; i++ )
	{
		if ( bHasRecords[ i ] )
		{
			pDayState[ nIndex ] |= 1 << i;
		}
	}
	
	// SET STATE AND CLEAN UP
	//
	m_ctlMonthCalendar.SetDayState(nCount, pDayState);

	delete [] pDayState;	
}

void CSetupDlg::OnTimer(UINT_PTR nIDEvent)
{
	// LOCAL TIME POSITION
	//
	if( nIDEvent == 0x00000000 ) 
	{
		for ( ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++ )		
		{
			if( m_pScfFile[ i ] != NULL ) 
			{
				double dLocalSampleTime = 0;

				QCAP_GET_FILE_POSITION( m_pScfFile[ i ], &dLocalSampleTime );

				ULONGLONG nLocalPlayTime = (ULONGLONG)(dLocalSampleTime * 10000000);

				if ( nLocalPlayTime > 0 )
				{
					SYSTEMTIME timeLocalPlay; FileTimeToSystemTime( (FILETIME *)(&nLocalPlayTime), &timeLocalPlay);

					SystemTimeToVariantTime(&timeLocalPlay, &m_oRecordWindows.m_dLocalPlayTime[ i ]);
				}
				else
				{
					m_oRecordWindows.m_dLocalPlayTime[ i ] = 0.0;
				}

				m_oRecordWindows.UpdateIndividualTrianglePointer( i );
			}
		}
	}

	// GLOBAL TIME POSITION
	//
	if( nIDEvent == 0x00000001 ) 
	{
		double dGlobalSampleTime = 0;

		QCAP_GET_GLOBAL_SCF_FILE_POSITION( &dGlobalSampleTime );

		ULONGLONG nGlobalPlayTime = (ULONGLONG)(dGlobalSampleTime * 10000000);

		if ( nGlobalPlayTime > 0 )
		{
			SYSTEMTIME timeGlobalPlay; FileTimeToSystemTime( (FILETIME *)(&nGlobalPlayTime), &timeGlobalPlay);

			SystemTimeToVariantTime(&timeGlobalPlay, &m_oRecordWindows.m_dGlobalPlayTime);
		}
		else
		{
			m_oRecordWindows.m_dGlobalPlayTime = 0.0;
		}

		m_oRecordWindows.UpdateGlobalTrianglePointer();
	}
}

void CSetupDlg::OnBnClickedBtnPlay1()
{
	// TODO: Add your control notification handler code here

	m_bChkCH01 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 0 );

	m_oRecordWindows.UpdateGlobalDataRect( 0 );	

	if ( m_pScfFile[ 0 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 0 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause1()
{
	// TODO: Add your control notification handler code here

	m_bChkCH01 = FALSE;

	UpdateData( FALSE );

	if ( m_pScfFile[ 0 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 0 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop1()
{
	// TODO: Add your control notification handler code here

	m_bChkCH01 = FALSE;

	UpdateData( FALSE );

	if ( m_pScfFile[ 0 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 0 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay2()
{
	// TODO: Add your control notification handler code here

	m_bChkCH02 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 1 );

	m_oRecordWindows.UpdateGlobalDataRect( 1 );

	if ( m_pScfFile[ 1 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 1 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause2()
{
	// TODO: Add your control notification handler code here

	m_bChkCH02 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 1 );

	if ( m_pScfFile[ 1 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 1 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop2()
{
	// TODO: Add your control notification handler code here

	m_bChkCH02 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 1 );

	if ( m_pScfFile[ 1 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 1 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay3()
{
	// TODO: Add your control notification handler code here

	m_bChkCH03 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 2 );

	m_oRecordWindows.UpdateGlobalDataRect( 2 );

	if ( m_pScfFile[ 2 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 2 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause3()
{
	// TODO: Add your control notification handler code here

	m_bChkCH03 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 2 );

	if ( m_pScfFile[ 2 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 2 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop3()
{
	// TODO: Add your control notification handler code here

	m_bChkCH03 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 2 );

	if ( m_pScfFile[ 2 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 2 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay4()
{
	// TODO: Add your control notification handler code here

	m_bChkCH04 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 3 );

	m_oRecordWindows.UpdateGlobalDataRect( 3 );

	if ( m_pScfFile[ 3 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 3 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause4()
{
	// TODO: Add your control notification handler code here

	m_bChkCH04 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 3 );

	if ( m_pScfFile[ 3 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 3 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop4()
{
	// TODO: Add your control notification handler code here

	m_bChkCH04 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 3 );

	if ( m_pScfFile[ 3 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 3 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay5()
{
	// TODO: Add your control notification handler code here

	m_bChkCH05 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 4 );

	m_oRecordWindows.UpdateGlobalDataRect( 4 );

	if ( m_pScfFile[ 4 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 4 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause5()
{
	// TODO: Add your control notification handler code here

	m_bChkCH05 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 4 );

	if ( m_pScfFile[ 4 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 4 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop5()
{
	// TODO: Add your control notification handler code here

	m_bChkCH05 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 4 );

	if ( m_pScfFile[ 4 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 4 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay6()
{
	// TODO: Add your control notification handler code here

	m_bChkCH06 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 5 );

	m_oRecordWindows.UpdateGlobalDataRect( 5 );

	if ( m_pScfFile[ 5 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 5 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause6()
{
	// TODO: Add your control notification handler code here

	m_bChkCH06 = FALSE;

	UpdateData( FALSE );	

	m_oRecordWindows.UpdateGlobalDataRect( 5 );

	if ( m_pScfFile[ 5 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 5 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop6()
{
	// TODO: Add your control notification handler code here

	m_bChkCH06 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 5 );

	if ( m_pScfFile[ 5 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 5 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay7()
{
	// TODO: Add your control notification handler code here

	m_bChkCH07 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 6 );

	m_oRecordWindows.UpdateGlobalDataRect( 6 );

	if ( m_pScfFile[ 6 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 6 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause7()
{
	// TODO: Add your control notification handler code here

	m_bChkCH07 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 6 );

	if ( m_pScfFile[ 6 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 6 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop7()
{
	// TODO: Add your control notification handler code here

	m_bChkCH07 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 6 );

	if ( m_pScfFile[ 6 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 6 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay8()
{
	// TODO: Add your control notification handler code here

	m_bChkCH08 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 7 );

	m_oRecordWindows.UpdateGlobalDataRect( 7 );

	if ( m_pScfFile[ 7 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 7 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause8()
{
	// TODO: Add your control notification handler code here

	m_bChkCH08 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 7 );

	if ( m_pScfFile[ 7 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 7 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop8()
{
	// TODO: Add your control notification handler code here

	m_bChkCH08 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 7 );

	if ( m_pScfFile[ 7 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 7 ] ); }
}

void CSetupDlg::OnBnClickedBtnPlay9()
{
	// TODO: Add your control notification handler code here

	m_bChkCH09 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.SetPlayState( 8 );

	m_oRecordWindows.UpdateGlobalDataRect( 8 );

	if ( m_pScfFile[ 8 ] != NULL ) { QCAP_PLAY_FILE( m_pScfFile[ 8 ] ); }
}

void CSetupDlg::OnBnClickedBtnPause9()
{
	// TODO: Add your control notification handler code here

	m_bChkCH09 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 8 );

	if ( m_pScfFile[ 8 ] != NULL ) { QCAP_PAUSE_FILE( m_pScfFile[ 8 ] ); }
}

void CSetupDlg::OnBnClickedBtnStop9()
{
	// TODO: Add your control notification handler code here

	m_bChkCH09 = FALSE;

	UpdateData( FALSE );

	m_oRecordWindows.UpdateGlobalDataRect( 8 );

	if ( m_pScfFile[ 8 ] != NULL ) { QCAP_STOP_FILE( m_pScfFile[ 8 ] ); }
}

void CSetupDlg::OnBnClickedChkCh01()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 0 );	

	m_oRecordWindows.SetPlayState( 0 );
}


void CSetupDlg::OnBnClickedChkCh02()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 1 );

	m_oRecordWindows.SetPlayState( 1 );
}


void CSetupDlg::OnBnClickedChkCh03()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 2 );

	m_oRecordWindows.SetPlayState( 2 );
}


void CSetupDlg::OnBnClickedChkCh04()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 3 );

	m_oRecordWindows.SetPlayState( 3 );
}


void CSetupDlg::OnBnClickedChkCh05()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 4 );

	m_oRecordWindows.SetPlayState( 4 );
}


void CSetupDlg::OnBnClickedChkCh06()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 5 );

	m_oRecordWindows.SetPlayState( 5 );
}


void CSetupDlg::OnBnClickedChkCh07()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 6 );

	m_oRecordWindows.SetPlayState( 6 );
}


void CSetupDlg::OnBnClickedChkCh08()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 7 );

	m_oRecordWindows.SetPlayState( 7 );
}


void CSetupDlg::OnBnClickedChkCh09()
{
	// TODO: Add your control notification handler code here

	UpdateData();

	m_oRecordWindows.UpdateGlobalDataRect( 8 );

	m_oRecordWindows.SetPlayState( 8 );
}


void CSetupDlg::OnBnClickedBtnGlobalPlay()
{
	// TODO: Add your control notification handler code here

	m_bGlobalPlay = TRUE;

	UpdateData();

	m_oRecordWindows.SetPlayState( 0 );
	m_oRecordWindows.SetPlayState( 1 );
	m_oRecordWindows.SetPlayState( 2 );
	m_oRecordWindows.SetPlayState( 3 );
	m_oRecordWindows.SetPlayState( 4 );
	m_oRecordWindows.SetPlayState( 5 );
	m_oRecordWindows.SetPlayState( 6 );
	m_oRecordWindows.SetPlayState( 7 );
	m_oRecordWindows.SetPlayState( 8 );	

	QCAP_PLAY_GLOBAL_SCF_FILE();
}


void CSetupDlg::OnBnClickedBtnGlobalPause()
{
	// TODO: Add your control notification handler code here

	QCAP_PAUSE_GLOBAL_SCF_FILE();
}


void CSetupDlg::OnBnClickedBtnGlobalStop()
{
	// TODO: Add your control notification handler code here

	QCAP_STOP_GLOBAL_SCF_FILE();

	m_bGlobalPlay = FALSE;
}


void CSetupDlg::OnBnClickedBtnSearch()
{
	// TODO: Add your control notification handler code here

	ShowRecordsDay();
}
