//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"
#include "stdio.h"
#include <VFW.H>
#include "QCAP.BCB.H"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TForm1 *Form1;
HINSTANCE hQCAP = NULL;
PVOID m_hVideoDevice = NULL;

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::OnAppCreate(TObject *Sender)
{
    // INITIALIZE COM RESOURCE
    //
    HRESULT hr = CoInitialize( NULL );

    hQCAP = LoadLibrary( "QCAP.DLL" );

    GET_FUNCTION_ADDRESS( hQCAP );

    QCAP_CREATE("SA7160 PCI", 0, Form1->Handle, &m_hVideoDevice, 1);

    QCAP_RUN( m_hVideoDevice );

    QCAP_SNAPSHOT_BMP( m_hVideoDevice, "C:\\BCB2.BMP" );
}
//---------------------------------------------------------------------------
void __fastcall TForm1::OnAppDestroy(TObject *Sender)
{

    // HARDWARE UNINITILIZE
    //
    if ( m_hVideoDevice != 0 )
    {
        if( QCAP_STOP == NULL )
        {
          ShowMessage( "Can not Point to QCAP_STOP()!!" );
          return;
        }
      	QCAP_STOP( m_hVideoDevice );

      	QCAP_DESTROY( m_hVideoDevice );

      	m_hVideoDevice = NULL;
    }

    FreeLibrary( hQCAP );

    // UNINITIALIZE COM RESOURCE
    //
    CoUninitialize();
}
//---------------------------------------------------------------------------
